/*
 * Decompiled with CFR 0.152.
 */
package net.feed_the_beast.launcher.json.versions;

import java.util.List;
import java.util.Map;
import net.feed_the_beast.launcher.json.versions.Action;
import net.feed_the_beast.launcher.json.versions.ExtractRule;
import net.feed_the_beast.launcher.json.versions.OS;
import net.feed_the_beast.launcher.json.versions.OSRule;
import net.ftb.data.Settings;
import net.ftb.util.DownloadUtils;

public class Library {
    public String name;
    public List<OSRule> rules;
    public Map<OS, String> natives;
    public ExtractRule extract;
    public String url;
    public boolean localRepo;
    public List<String> checksums;
    public Boolean download;
    private Action _applies = null;
    private Artifact _artifact = null;

    public boolean applies() {
        if (this._applies == null) {
            this._applies = Action.DISALLOW;
            if (this.rules == null) {
                this._applies = Action.ALLOW;
            } else {
                for (OSRule rule : this.rules) {
                    if (!rule.applies()) continue;
                    this._applies = rule.action;
                }
            }
        }
        return this._applies == Action.ALLOW;
    }

    public String getPath() {
        if (this._artifact == null) {
            this._artifact = new Artifact(this.name);
        }
        return this._artifact.getPath();
    }

    public String getPathNatives() {
        if (this.natives == null) {
            return null;
        }
        if (this._artifact == null) {
            this._artifact = new Artifact(this.name);
        }
        return this._artifact.getPath(this.natives.get((Object)OS.CURRENT).replace("${arch}", Settings.getSettings().getCurrentJava().is64bits ? "64" : "32"));
    }

    public String getUrl() {
        return this.url == null ? (this.localRepo ? DownloadUtils.getCreeperhostLink("maven/") : "https://libraries.minecraft.net/") : this.url;
    }

    public String toString() {
        return this.name;
    }

    private class Artifact {
        private String domain;
        private String name;
        private String version;
        private String classifier;
        private String ext = "jar";

        public Artifact(String rep) {
            String[] pts = rep.split(":");
            int idx = pts[pts.length - 1].indexOf(64);
            if (idx != -1) {
                this.ext = pts[pts.length - 1].substring(idx + 1);
                pts[pts.length - 1] = pts[pts.length - 1].substring(0, idx);
            }
            this.domain = pts[0];
            this.name = pts[1];
            this.version = pts[2];
            if (pts.length > 3) {
                this.classifier = pts[3];
            }
        }

        public String getPath() {
            return this.getPath(this.classifier);
        }

        public String getPath(String classifier) {
            String ret = String.format("%s/%s/%s/%s-%s", this.domain.replace('.', '/'), this.name, this.version, this.name, this.version);
            if (classifier != null) {
                ret = ret + "-" + classifier;
            }
            return ret + "." + this.ext;
        }
    }
}

